/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: tcp.c,v 1.17 2005/06/29 00:23:16 eugene Exp $";

/*
 *  Routines that take tcp stuff as arguments
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "internal.h"
#include "tcp.h"

/*
 * Create a new address descriptor structure
 */
struct mx_address_desc *
mx_new_address_desc(mx_endpoint_addr_t address)
{
  struct mx_address_desc *edp;

  edp = (struct mx_address_desc *)malloc(sizeof(*edp));
  if (edp == NULL) {
    return NULL;
  }

  /* fill it in */
  edp->address = address;
  edp->send_sock = -1;
  edp->recv_sock = -1;
  return edp;
}

void
mx_destroy_address_desc(struct mx_address_desc* ep)
{
  if (ep->send_sock != -1) {
    close(ep->send_sock);
    ep->send_sock = -1;
  }
  if (ep->recv_sock != -1) {
    close(ep->recv_sock);
    ep->recv_sock = -1;
  }
  MX_LIST_REMOVE(ep);
  free(ep);
}


/*
 * find an address descriptor if it is in the list of known addresss, else
 * allocate a structure and add it to the list
 */
struct mx_address_desc *
mx_get_address_desc(struct mx_endpoint *endpoint,
                       mx_endpoint_addr_t address)
{
  struct mx_address_desc *ed;

  /* XXX use MX_LIST_FIND */
  /* see if we can find descriptor for this address */
  for (ed = endpoint->known_addresss.next;
       ed != &endpoint->known_addresss;
       ed = ed->next) {
    if (memcmp(&address, &ed->address, sizeof(address)) == 0) {
      break;
    }
  }
  
  /* If no address struct found, create one and put at the head of the list */
  if (ed == &endpoint->known_addresss) {
    ed = mx_new_address_desc(address);

    /* if we successfully got a struct, add it to list */
    if (ed != NULL) {
      MX_LIST_INSERT(&endpoint->known_addresss, ed);
    }
  }

  return ed;
}

#if 0
void
mx_destroy_address_descs(struct mx_address_desc **head)
{
  struct mx_address_desc *p, *q;

  p = *head;
  while (p != NULL) {
    q = p;
    p = p->next;
    free(q);
  }
  *head = NULL;
}
#endif
